<?php
namespace Opencart\Catalog\Controller\Extension\Seopro\Other;

class Seopro extends \Opencart\System\Engine\Controller {

	public function eventAddHreflang(string &$route, array &$data, mixed &$output): void {
		if ($this->config->get('other_seopro_status')) {

			$this->load->model('localisation/language');
			$languages = $this->model_localisation_language->getLanguages();

			if (count($languages) > 1) {
				$current_language_id = $this->config->get('config_language_id');
				$hreflangs = [];
				$hreflang_code = '';
				$url_data = '';
				$url = '';
				
				$url_data = $this->request->get;
					
				if (isset($url_data['route'])) {
					$route_ = $url_data['route'];
				} else {
					$route_ = $this->config->get('action_default');
				}
			
				unset($url_data['route']);
				unset($url_data['_route_']);
				unset($url_data['language']);
				
				if (!empty($url_data['product_id'])) {
					unset($url_data['path']);
					unset($url_data['manufacturer_id']);
				}
					
				if ($url_data) {
					$url .= '&' . urldecode(http_build_query($url_data));
				}

				foreach ($languages as $language) {

					$this->config->set('config_language_id', $language['language_id']);
					$href = $this->url->link($route_, 'language=' . $language['code'] . $url);
						
					if ($this->config->get('other_seopro_language_xdefault') == $language['language_id']) {
						$hreflang_code .= '<link rel="alternate" hreflang="x-default" href="' . $href . '">';
					}
					if (!empty($this->config->get('other_seopro_language_hreflang')[$language['language_id']])) {
						$hreflang_code .= '<link rel="alternate" hreflang="' . $this->config->get('other_seopro_language_hreflang')[$language['language_id']] . '" href="' . $href . '">';
					}

				}

				$this->config->set('config_language_id', $current_language_id);

				$output = str_replace('</head>', $hreflang_code . '</head>', $output);
			}
		}
	}

}