<?php
namespace Opencart\Admin\Model\Extension\Seopro\Other;

class Seopro extends \Opencart\System\Engine\Model {

	public function install(): void {
		$query = $this->db->query("DESCRIBE " . DB_PREFIX . "product_to_category `main_category`");
		if ($query->num_rows == 0) {
			$this->db->query("ALTER TABLE " . DB_PREFIX ."product_to_category ADD `main_category` tinyint(1) COLLATE utf8_general_ci NOT NULL DEFAULT '0' AFTER `category_id`");
		}
	}

	public function uninstall(): void {
		$query = $this->db->query("DESCRIBE " . DB_PREFIX . "product_to_category `main_category`");
		if ($query->num_rows != 0) {
			$this->db->query("ALTER TABLE " . DB_PREFIX ."product_to_category DROP COLUMN `main_category`");
		}
	}

	public function addSeoUrls(array $new_seourls): void {
		$values = '';
		foreach ($new_seourls as $seourl) {
			$values .= "('" . implode("', '", array_values($seourl)) . "'),";
		}
		$values = rtrim($values, ',');
		if ($values) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "seo_url (`store_id`,`language_id`,`key`,`value`,`keyword`,`sort_order`) VALUES " . $values);
		}
	}

	public function deleteSeoUrlByKey(int $store_id, int $language_id, string $key): void {
		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE store_id = " . (int)$store_id . " AND language_id = " . (int)$language_id . " AND `key` = '" . $this->db->escape($key) . "'");
	}

	public function deleteSeoUrlByValue(int $store_id, int $language_id, string $value): void {
		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE store_id = " . (int)$store_id . " AND language_id = " . (int)$language_id . " AND `value` = '" . $this->db->escape($value) . "'");
	}

	public function getPagesByLanguage(string $type, int $language_id): array {
		if ($type == 'manufacturer') {
			$show_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . $type . "_description'");
			if ($show_table->num_rows) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . $type . " t LEFT JOIN " . DB_PREFIX . $type . "_description td ON (t." . $type . "_id = td." . $type . "_id) WHERE td.language_id = " . (int)$language_id);
			} else {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . $type);
			}
		} else {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . $type . " t LEFT JOIN " . DB_PREFIX . $type . "_description td ON (t." . $type . "_id = td." . $type . "_id) WHERE td.language_id = " . (int)$language_id);
		}
		return $query->rows;
	}

	public function getSeoUrlByType(int $store_id, int $language_id, string $type): array {
		$result = [];

		if ($type == 'route' || $type == 'language') {
			$key = $type;
		} elseif ($type == 'category') {
			$key = 'path';
		} else {
			$key = $type . "_id";
		}

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE store_id = " . (int)$store_id . " AND language_id = " . (int)$language_id . " AND `key` = '" . $this->db->escape($key) . "'");

		if ($query->num_rows) {
			foreach ($query->rows as $row) {
				$result[$row['store_id']][$row['language_id']][$row['key'].'='.$row['value']] = $row['keyword'];
			}
		}

		return $result;
	}

	public function getLanguageSeoUrl(): array {
		$result = [];

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE `key` = 'language'");

		if ($query->num_rows) {
			foreach ($query->rows as $row) {
				$result[$row['store_id']][$row['language_id']] = $row['keyword'];
			}
		}

		return $result;
	}

	public function deleteLanguageSeoUrl(): void {
		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE `key` = 'language'");
	}

	public function getCategoryPath(int $category_id): string {
		$path = [];
		while ($category_id) {
			$query = $this->db->query("SELECT parent_id, category_id FROM " . DB_PREFIX . "category WHERE category_id = '" . (int)$category_id . "'");
			if ($query->num_rows) {
				$path[] = $query->row['category_id'];
				$category_id = $query->row['parent_id'];
			} else {
				break;
			}
		}

		$full_path = implode('_', array_reverse($path));

		return $full_path;
	}

}