<?php
namespace Opencart\Admin\Controller\Extension\Seopro\Other;

class Seopro extends \Opencart\System\Engine\Controller {

	private $error = [];
	private $startups = [];
	private $events = [];
	private $token_var;
	private $separator;
	private $trigger_separator;
	private $confirm = false;
	private $extension_type = 'other';
	private $extension_path = 'seopro';
	private $extension_name = 'seopro';
	private $prefix;
	private $prefix_main;
	private $extension_route;
	
	public function __construct($registry) {
		parent::__construct($registry);
		$this->token_var		= 'user_token';
		$this->separator		= version_compare(VERSION,'4.0.2.0', '>=') ? '.' : '|';
		$this->trigger_separator= version_compare(VERSION,'4.0.2.3', '>') ? '.' : '/';
		$this->prefix_main		= $this->extension_type.'_'.$this->extension_name;
		$this->prefix			= $this->prefix_main.'_';
		$this->extension_route	= 'extension/'.$this->extension_path.'/'.$this->extension_type.'/'.$this->extension_name;
		$this->startups 		= [
			[
				'code'			=> 'seo_url',
				'action'		=> 'catalog/extension/seopro/startup/seo_url',
				'description'	=> 'SEO URL Fix',
				'sort_order'	=> 1,
				'status'		=> true
			]
		];
		$this->events 		= [
			[
				'code'			=> $this->extension_name.'_main_category_field',
				'trigger'		=> 'admin/view/catalog/product_form/after',
				'action'		=> 'extension/seopro/event/main_category'. $this->separator . 'addMainCategoryField',
				'description'	=> 'Add the main category field in the product form for breadcrumbs and SEO URL creation',
				'sort_order'	=> 1,
				'status'		=> true
			],
			[
				'code'			=> $this->extension_name.'_main_category_add',
				'trigger'		=> 'admin/model/catalog/product'. $this->trigger_separator . 'addProduct/after',
				'action'		=> 'extension/seopro/event/main_category'. $this->separator . 'onProductSave',
				'description'	=> 'Save the main category from the product form',
				'sort_order'	=> 1,
				'status'		=> true
			],
			[
				'code'			=> $this->extension_name.'_main_category_edit',
				'trigger'		=> 'admin/model/catalog/product'. $this->trigger_separator . 'editProduct/after',
				'action'		=> 'extension/seopro/event/main_category'. $this->separator . 'onProductSave',
				'description'	=> 'Save the main category from the product form',
				'sort_order'	=> 1,
				'status'		=> true
			],
			[
				'code'			=> $this->extension_name.'_hreflang',
				'trigger'		=> 'catalog/view/common/header/after',
				'action'		=> $this->extension_route . $this->separator . 'eventAddHreflang',
				'description'	=> 'Add the hreflang links on head section',
				'sort_order'	=> 1,
				'status'		=> true
			]
		];
	}

	public function install(): void {
		$this->load->model('setting/startup');
		foreach($this->startups as $startup) {
			if (!$this->model_setting_startup->getStartupByCode($startup['code'])) {
				$this->model_setting_startup->addStartup($startup);
			}
		}
		$this->load->model('setting/event');
		foreach($this->events as $event) {
			if (!$this->model_setting_event->getEventByCode($event['code'])) {
				$this->model_setting_event->addEvent($event);
			}
		}
		$this->load->model('extension/seopro/other/seopro');
		$this->model_extension_seopro_other_seopro->install();
	}

	public function uninstall(): void {
		$this->load->model('setting/startup');
		foreach($this->startups as $startup) {
			$this->model_setting_startup->deleteStartupByCode($startup['code']);
		}
		$this->load->model('setting/event');
		foreach($this->events as $event) {
			$this->model_setting_event->deleteEventByCode($event['code']);
		}
		$this->load->model('extension/seopro/other/seopro');
		$this->model_extension_seopro_other_seopro->uninstall();
	}

	public function index(): void {
		$this->load->language($this->extension_route);

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->token_var . '=' . $this->session->data[$this->token_var], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', $this->token_var . '=' . $this->session->data[$this->token_var] . '&type='.$this->extension_type, true)
		];
		
		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link($this->extension_route, $this->token_var . '=' . $this->session->data[$this->token_var], true)
		];

		$data['separator'] = $this->separator;
		$data['prefix'] = $this->prefix;
		$data['token_var'] = $this->token_var;
		$data[$this->token_var] = $this->session->data[$this->token_var];
		$data['has_blog'] = version_compare(VERSION,'4.0.2.3', '>=') ? true : false;

		$data['save'] = $this->url->link($this->extension_route.$this->separator.'save', $this->token_var . '=' . $this->session->data[$this->token_var], true);
		$data['back'] = $this->url->link('marketplace/extension', $this->token_var . '=' . $this->session->data[$this->token_var] . '&type='.$this->extension_type, true);

		$this->load->model('setting/store');
		$multistores = $this->model_setting_store->getStores();
		$stores = [];
		$stores[] = [
			'store_id' => 0,
			'name' => $this->config->get('config_name')
		];
		if ($multistores) {
			foreach ($multistores as $store) {
				$stores[] = [
					'store_id' => $store['store_id'],
					'name' => $store['name']
				];
			}
		}
		$data['stores'] = $stores;

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if ($this->config->get($this->prefix.'status')) {
			$data[$this->prefix.'status'] = $this->config->get($this->prefix.'status');
		} else {
			$data[$this->prefix.'status'] = 0;
		}

		if ($this->config->get('config_language_catalog')) {
			$data[$this->prefix.'language_default'] = $this->config->get('config_language_catalog');
		} else {
			$data[$this->prefix.'language_default'] = $this->config->get('config_language');
		}

		if ($this->config->get($this->prefix.'language_dir')) {
			$data[$this->prefix.'language_dir'] = $this->config->get($this->prefix.'language_dir');
		} else {
			$data[$this->prefix.'language_dir'] = [];
		}

		if ($this->config->get($this->prefix.'language_hreflang')) {
			$data[$this->prefix.'language_hreflang'] = $this->config->get($this->prefix.'language_hreflang');
		} else {
			$data[$this->prefix.'language_hreflang'] = [];
		}

		if ($this->config->get($this->prefix.'language_xdefault')) {
			$data[$this->prefix.'language_xdefault'] = $this->config->get($this->prefix.'language_xdefault');
		} else {
			$data[$this->prefix.'language_xdefault'] = 0;
		}

		if ($this->config->get($this->prefix.'product_dir')) {
			$data[$this->prefix.'product_dir'] = $this->config->get($this->prefix.'product_dir');
		} else {
			$data[$this->prefix.'product_dir'] = 0;
		}

		if ($this->config->get($this->prefix.'product_include')) {
			$data[$this->prefix.'product_include'] = $this->config->get($this->prefix.'product_include');
		} else {
			$data[$this->prefix.'product_include'] = '';
		}

		if ($this->config->get($this->prefix.'product_end')) {
			$data[$this->prefix.'product_end'] = $this->config->get($this->prefix.'product_end');
		} else {
			$data[$this->prefix.'product_end'] = '';
		}

		if ($this->config->get($this->prefix.'category_dir')) {
			$data[$this->prefix.'category_dir'] = $this->config->get($this->prefix.'category_dir');
		} else {
			$data[$this->prefix.'category_dir'] = 0;
		}

		if ($this->config->get($this->prefix.'category_flat')) {
			$data[$this->prefix.'category_flat'] = $this->config->get($this->prefix.'category_flat');
		} else {
			$data[$this->prefix.'category_flat'] = 0;
		}

		if ($this->config->get($this->prefix.'category_end')) {
			$data[$this->prefix.'category_end'] = $this->config->get($this->prefix.'category_end');
		} else {
			$data[$this->prefix.'category_end'] = '';
		}

		if ($this->config->get($this->prefix.'manufacturer_dir')) {
			$data[$this->prefix.'manufacturer_dir'] = $this->config->get($this->prefix.'manufacturer_dir');
		} else {
			$data[$this->prefix.'manufacturer_dir'] = 0;
		}

		if ($this->config->get($this->prefix.'manufacturer_end')) {
			$data[$this->prefix.'manufacturer_end'] = $this->config->get($this->prefix.'manufacturer_end');
		} else {
			$data[$this->prefix.'manufacturer_end'] = '';
		}

		if ($this->config->get($this->prefix.'information_dir')) {
			$data[$this->prefix.'information_dir'] = $this->config->get($this->prefix.'information_dir');
		} else {
			$data[$this->prefix.'information_dir'] = 0;
		}

		if ($this->config->get($this->prefix.'information_end')) {
			$data[$this->prefix.'information_end'] = $this->config->get($this->prefix.'information_end');
		} else {
			$data[$this->prefix.'information_end'] = '';
		}

		if ($this->config->get($this->prefix.'blog_dir')) {
			$data[$this->prefix.'blog_dir'] = $this->config->get($this->prefix.'blog_dir');
		} else {
			$data[$this->prefix.'blog_dir'] = 0;
		}

		if ($this->config->get($this->prefix.'topic_end')) {
			$data[$this->prefix.'topic_end'] = $this->config->get($this->prefix.'topic_end');
		} else {
			$data[$this->prefix.'topic_end'] = '';
		}

		if ($this->config->get($this->prefix.'article_end')) {
			$data[$this->prefix.'article_end'] = $this->config->get($this->prefix.'article_end');
		} else {
			$data[$this->prefix.'article_end'] = '';
		}

		if ($this->config->get($this->prefix . 'separator')) {
			$data[$this->prefix . 'separator'] = $this->config->get($this->prefix . 'separator');
		} else { 
			$data[$this->prefix . 'separator'] = '-';
		}

		if ($this->config->get($this->prefix . 'replace')) {
			$data[$this->prefix . 'replace'] = $this->config->get($this->prefix . 'replace');
		} else { 
			$data[$this->prefix . 'replace'] = '';
		}

		if ($this->config->get($this->prefix . 'sameurl')) {
			$data[$this->prefix . 'sameurl'] = $this->config->get($this->prefix . 'sameurl');
		} else { 
			$data[$this->prefix . 'sameurl'] = 0;
		}

		if ($this->config->get($this->prefix . 'baselang')) {
			$data[$this->prefix . 'baselang'] = $this->config->get($this->prefix . 'baselang');
		} else { 
			$data[$this->prefix . 'baselang'] = '';
		}

		if ($this->config->get($this->prefix . 'rewrite')) {
			$data[$this->prefix . 'rewrite'] = $this->config->get($this->prefix . 'rewrite');
		} else { 
			$data[$this->prefix . 'rewrite'] = 0;
		}

		if ($this->config->get($this->prefix.'license')) {
			$data[$this->prefix.'license'] = $this->config->get($this->prefix.'license');
		} else {
			$data[$this->prefix.'license'] = '';
		}

		$this->load->model('extension/seopro/other/seopro');
		$data[$this->prefix . 'language_seourl'] = $this->model_extension_seopro_other_seopro->getLanguageSeoUrl();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->extension_route, $data));
	}

	public function save(): void {
		$this->load->language($this->extension_route);

		$json = [];

		if (!$this->user->hasPermission('modify', $this->extension_route)) {
			$json['error'] = $this->language->get('error_permission');
		}

		if (!empty($this->request->post[$this->prefix.'license']) && !empty($_SERVER['SERVER_NAME'])) {   
			$domain = preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']);
			$server = HTTP_SERVER;
			$parse_domain = parse_url($server);
			$config_domain = preg_replace('/^www\./', '', $parse_domain['host']);
			if ($domain == $config_domain) {
				if (filter_input(INPUT_POST, $this->prefix.'license', FILTER_SANITIZE_SPECIAL_CHARS)!=hash('sha256', $this->extension_name . $domain . base64_decode('RGFSeU5hMw=='))) {
					$json['error'] = $this->language->get('error_license3');
				} else {
					$this->confirm = true;
				}
			} else {
				$json['error'] = $this->language->get('error_license2') . ' '.$domain.' ('.$config_domain.')';
			}
		} else {
			$json['error'] = $this->language->get('error_license1');
		}

		if (!$json && $this->confirm) {
			$this->load->model('setting/setting');
			$this->model_setting_setting->editSetting($this->prefix_main, $this->request->post);

			$this->load->model('localisation/language');
			$languages = $this->model_localisation_language->getLanguages();
			$language_code = [];
			foreach ($languages as $language) {
				$language_code[$language['language_id']] = $language['code'];
			}

			$this->load->model('extension/seopro/other/seopro');
			$this->model_extension_seopro_other_seopro->deleteLanguageSeoUrl();

			$language_seourls = [];
			foreach ($this->request->post['other_seopro_language_seourl'] as $store_id => $seo_url) {
				foreach ($seo_url as $language_id => $keyword) {
					if ($keyword) {
						$language_seourls[] = [
							'store_id' => (int)$store_id,
							'language_id' => (int)$language_id,
							'key' => 'language',
							'value' => $language_code[$language_id],
							'keyword' => $keyword,
							'sort_order' => $this->getSortOrder('language')
						];
					}
				}
			}

			if (!empty($language_seourls)) {
				$this->model_extension_seopro_other_seopro->addSeoUrls($language_seourls);
			}

			$json['success'] = $this->language->get('text_success');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function generate(): void {
		$this->load->language('extension/seopro/other/seopro');
		$count_seourl = 0;
		$json = [];

		if ($this->validateGeneration()) {
			$this->load->model('extension/seopro/other/seopro');

			if (!empty($this->request->get['type'])) {
				$type = $this->request->get['type'];
			} else {
				$type = '';
			}

			if (!empty($this->request->post)) {
				$rewrite = $this->request->post[$this->prefix . 'rewrite'];
				$sameurl = $this->request->post[$this->prefix . 'sameurl'];
				$baselang = $this->request->post[$this->prefix . 'baselang'];
				$separator = $this->request->post[$this->prefix . 'separator'];
				$replace = $this->request->post[$this->prefix . 'replace'];
			} else {
				$rewrite = $this->config->get($this->prefix . 'rewrite');
				$sameurl = $this->config->get($this->prefix . 'sameurl');
				$baselang = $this->config->get($this->prefix . 'baselang');
				$separator = $this->config->get($this->prefix . 'separator');
				$replace = $this->config->get($this->prefix . 'replace');
			}

			if ($replace) {
				$replace_array = $this->parseReplaceRules($replace);
			} else {
				$replace_array = [];
			}

			$language_code = 'en';
			$existing_seourls = [];
			$path = [];

			$this->load->model('setting/store');
			$multistores = $this->model_setting_store->getStores();
			$stores = [];
			$stores[] = [
				'store_id' => 0
			];
			if ($multistores) {
				foreach ($multistores as $store) {
					$stores[] = [
						'store_id' => $store['store_id']
					];
				}
			}

			$this->load->model('localisation/language');
			$languages = $this->model_localisation_language->getLanguages();
			$count_languages = count($languages);

			if ($sameurl) {
				if ($type != 'route' && $type != 'language') {
					$pages = $this->model_extension_seopro_other_seopro->getPagesByLanguage($type, $baselang);
				}
				foreach ($languages as $language) {
					if ($language['language_id'] == $baselang) {
						$language_code = substr($language['code'], 0, 2);
						break;
					}
				}
			}

			foreach ($languages as $language) {
				$language_short = substr($language['code'], 0, 2);
				if (!$sameurl) {
					if ($type != 'route' && $type != 'language') {
						$pages = $this->model_extension_seopro_other_seopro->getPagesByLanguage($type, $language['language_id']);
					}
					$language_code = $language_short;
				}

				foreach ($stores as $store) {
					$new_seourls = [];
					if (!$rewrite) {
						$existing_seourls = $this->model_extension_seopro_other_seopro->getSeoUrlByType($store['store_id'], $language['language_id'], $type);
					}
						
					if ($type == 'language') {
						if ($rewrite || (!$rewrite && !isset($existing_seourls[$store['store_id']][$language['language_id']]['language='.$language['code']]))) {
							if ($rewrite) {
								$this->model_extension_seopro_other_seopro->deleteSeoUrlByKey($store['store_id'], $language['language_id'], $type);
							}		
							$new_seourls[] = [
								'store_id' => (int)$store['store_id'],
								'language_id' => (int)$language['language_id'],
								'key' => 'language',
								'value' => $language['code'],
								'keyword' => $language_short,
								'sort_order' => $this->getSortOrder('language')
							];
						}
					} elseif ($type == 'route') {
						$pages = ['home','product','category','manufacturer','information','blog','special','search','compare','contact','sitemap','account','affiliate','checkout'];
						foreach ($pages as $page) {
							$routes = $this->getRoutes($page);
							foreach ($routes as $route) {
								if ($rewrite || (!$rewrite && !isset($existing_seourls[$store['store_id']][$language['language_id']]['route='.$route]))) {
									if ($rewrite) {
										$this->model_extension_seopro_other_seopro->deleteSeoUrlByValue($store['store_id'], $language['language_id'], $route);
									}
									$seo_url = $this->createSeoUrl($route);
									$new_seourls[] = [
										'store_id' => (int)$store['store_id'],
										'language_id' => (int)$language['language_id'],
										'key' => 'route',
										'value' => $route,
										'keyword' => $seo_url . (($seo_url&&!$sameurl&&$count_languages>1) ? $separator.$language_short : ''),
										'sort_order' => $this->getSortOrder($page)
									];
								}
							}
							
						}
					} elseif ($type == 'category') {
						if ($rewrite) {
							$this->model_extension_seopro_other_seopro->deleteSeoUrlByKey($store['store_id'], $language['language_id'], 'path');
						}
						foreach ($pages as $page) {
							if (empty($path[$page[$type.'_id']])) {
								$path[$page[$type.'_id']] = $this->model_extension_seopro_other_seopro->getCategoryPath($page[$type.'_id']);
							}
							if ($rewrite || (!$rewrite && !isset($existing_seourls[$store['store_id']][$language['language_id']]['path='.$path[$page[$type.'_id']]]))) {
								$page['name'] = isset($page['name']) ? $page['name'] : $page['title'];
								$new_seourls[] = [
									'store_id' => (int)$store['store_id'],
									'language_id' => (int)$language['language_id'],
									'key' => 'path',
									'value' => $path[$page[$type.'_id']],
									'keyword' => $this->db->escape($this->translitSeoUrl($page['name'], $separator, $language_code, $replace_array)),
									'sort_order' => 2
								];
							}
						}
					} else {
						if ($rewrite) {
							$this->model_extension_seopro_other_seopro->deleteSeoUrlByKey($store['store_id'], $language['language_id'], $type.'_id');
						}
						foreach ($pages as $page) {
							if ($rewrite || (!$rewrite && !isset($existing_seourls[$store['store_id']][$language['language_id']][$type.'_id='.$page[$type.'_id']]))) {
								$page['name'] = isset($page['name']) ? $page['name'] : $page['title'];
								$new_seourls[] = [
									'store_id' => (int)$store['store_id'],
									'language_id' => (int)$language['language_id'],
									'key' => $type.'_id',
									'value' => (int)$page[$type.'_id'],
									'keyword' => $this->db->escape($this->translitSeoUrl($page['name'], $separator, $language_code, $replace_array)),
									'sort_order' => 3
								];
							}
						}
					}

					if (!empty($new_seourls)) {
						$this->model_extension_seopro_other_seopro->addSeoUrls($new_seourls);
						$count_seourl += count($new_seourls);
					}
					
				}
			}

			$json['success'] = sprintf($this->language->get('text_success_generate'), $count_seourl);

		} else {
			if (isset($this->error['warning'])) {
				$json['error'] = $this->error['warning'];
			} else {
				$json['error'] = $this->language->get('error_permission');
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));

	}

	protected function translitSeoUrl(string $string, string  $separator, string $language_code, array $replace_array): string {
		require_once DIR_EXTENSION . 'seopro/system/library/seopro/vendor/autoload.php';

		// \URLify::remove_words($array_of_words, $language_code);
		// \URLify::add_chars(['A' => 'a', 'B' => 'b', 'C' => 'c']);
		// \URLify::slug($string, $maxLength = 200, $separator = '-', $language = 'en', $removeWords = true);

		if ($replace_array) {
			\URLify::add_chars($replace_array);
		}

		$seourl = \URLify::slug($string, 255, $separator, $language_code);

		return $seourl;
	}

	protected function parseReplaceRules($input) {
		$rules = [];
		$lines = preg_split('/\r\n|\r|\n/', $input);

		foreach ($lines as $line) {
			$line = trim($line);
			if (!$line) continue;

			if (strpos($line, '=') !== false) {
				list($from, $to) = explode('=', $line, 2);
				$from = trim($from);
				$to = trim($to);
				if ($from !== '') {
					$rules[$from] = $to;
				}
			}
		}

		return $rules;
	}
	
	protected function getRoutes(string $type): array {
		switch ($type) {
			case 'home':
				$pages = ['common/home'];
				break;
			case 'product':
				$pages = ['product/product'];
				break;
			case 'category':
				$pages = ['product/category'];
				break;
			case 'special':
				$pages = ['product/special'];
				break;
			case 'manufacturer':
				$pages = [
					'product/manufacturer',
					'product/manufacturer'.$this->separator.'info'
				];
				break;
			case 'blog':
				$pages = [
					'cms/blog',
					'cms/blog'.$this->separator.'info'
				];
				break;
			case 'search':
				$pages = ['product/search'];
				break;
			case 'compare':
				$pages = ['product/compare'];
				break;
			case 'information':
				$pages = ['information/information'];
				break;
			case 'contact':
				$pages = ['information/contact'];
				break;
			case 'sitemap':
				$pages = ['information/sitemap'];
				break;
			case 'account':
				$pages = [
					'account/account',
					'account/address',
					'account/affiliate',
					'account/authorize',
					'account/download',
					'account/edit',
					'account/forgotten',
					'account/login',
					'account/logout',
					'account/newsletter',
					'account/order',
					'account/password',
					'account/payment_method',
					'account/register',
					'account/returns',
					'account/returns'.$this->separator.'add',
					'account/returns'.$this->separator.'info',
					'account/returns'.$this->separator.'success',
					'account/returns'.$this->separator.'history',
					'account/reward',
					'account/subscription',
					'account/subscription'.$this->separator.'info',
					'account/subscription'.$this->separator.'order',
					'account/subscription'.$this->separator.'history',
					'account/success',
					'account/tracking',
					'account/transaction',
					'account/wishlist'
				];
				break;
			case 'affiliate':
				$pages = [
					'affiliate/edit',
					'affiliate/password',
					'affiliate/payment',
					'affiliate/tracking',
					'affiliate/transaction',
					'affiliate/logout',
					'affiliate/forgotten',
					'affiliate/register',
					'affiliate/login',
					'affiliate/account'
				];
				break;
			case 'checkout':
				$pages = [
					'checkout/cart',
					'checkout/checkout',
					'checkout/success',
					'checkout/failure',
					'checkout/voucher'
				];
				break;
			default:
				$pages = [];
				break;
		}
	
		return $pages;
	}

	protected function getSortOrder($page) {
		switch ($page) {
			case 'language':
				$sort_order = -99;
				break;
			case 'product':
			case 'category':
			case 'manufacturer':
			case 'information':
			case 'blog':
				$sort_order = -1;
				break;
			
			default:
				$sort_order = 99;
				break;
		}

		return $sort_order;
	}

	protected function createSeoUrl($route) {
		switch ($route) {
			case 'common/home':
				$seo_url = '';
				break;
			case 'product/category':
				$seo_url = 'category';
				break;
			case 'product/manufacturer':
				$seo_url = 'brands';
				break;
			case 'product/manufacturer'.$this->separator.'info':
				$seo_url = 'brand';
				break;
			case 'product/search':
				$seo_url = 'search';
				break;
			case 'product/special':
				$seo_url = 'special';
				break;
			case 'product/compare':
				$seo_url = 'compare';
				break;
			case 'information/information':
				$seo_url = 'page';
				break;
			case 'information/contact':
				$seo_url = 'contacts';
				break;
			case 'information/sitemap':
				$seo_url = 'sitemap';
				break;
			case 'account/wishlist':
				$seo_url = 'wishlist';
				break;
			case 'account/register':
				$seo_url = 'register';
				break;
			case 'account/login':
				$seo_url = 'login';
				break;
			case 'account/logout':
				$seo_url = 'logout';
				break;
			case 'account/order':
				$seo_url = 'order-history';
				break;
			case 'account/newsletter':
				$seo_url = 'newsletter';
				break;
			case 'checkout/cart':
				$seo_url = 'cart';
				break;
			case 'cms/blog':
				$seo_url = 'blogs';
				break;
			case 'cms/blog'.$this->separator.'info':
				$seo_url = 'blog';
				break;
			default:
				$delimiters = ['/', $this->separator];
				$route_str = str_replace($delimiters, $delimiters[0], $route);
				$route_array = explode('/', $route_str);
				if ($route_array[0] == $route_array[1]){
					unset($route_array[1]);
				}
				$seo_url = $this->db->escape(implode($this->config->get($this->prefix . 'separator'), $route_array));
				break;
		}
		
		return $seo_url;
	}

	protected function validateGeneration(): bool {
		if (!$this->config->get($this->prefix . 'status') || !$this->user->hasPermission('modify', 'extension/seopro/other/seopro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}

}