<?php
namespace Opencart\Admin\Controller\Extension\Seopro\Event;

class MainCategory extends \Opencart\System\Engine\Controller {

	public function addMainCategoryField(string &$route, array &$data, string &$output): void {
		if ($route === 'catalog/product_form') {
			$this->load->language('extension/seopro/event/main_category');

			$product_id = $data['product_id'] ?? 0;

			$mainCategoryHtml = '
				<div class="row mb-3">
					<label for="input-main-category" class="col-sm-2 col-form-label">' . $this->language->get('text_main_category') . '</label>
					<div class="col-sm-10">
						<select name="main_category" id="input-main-category" class="form-select">
							<option value="0">' . $this->language->get('text_none') . '</option>
							' . $this->getCategoriesOptions($product_id) . '
						</select>
					</div>
				
					<script>
						document.addEventListener("DOMContentLoaded", function() {
							const mainCategorySelect = document.getElementById("input-main-category");
							const categoryTable = document.getElementById("product-category");

							if (mainCategorySelect && categoryTable) {
								mainCategorySelect.addEventListener("change", function() {
									const selectedCategoryId = mainCategorySelect.value;
									const selectedCategoryName = mainCategorySelect.options[mainCategorySelect.selectedIndex].text;

									if (selectedCategoryId && selectedCategoryId !== "0") {
										const exists = Array.from(categoryTable.querySelectorAll("input[name=\'product_category[]\']")).some(input => input.value === selectedCategoryId);

										if (!exists) {
											const row = document.createElement("tr");
											row.id = "product-category-" + selectedCategoryId;
											row.innerHTML = `
												<td>${selectedCategoryName}<input type="hidden" name="product_category[]" value="${selectedCategoryId}"/></td>
												<td class="text-end">
													<button type="button" class="btn btn-danger">
														<i class="fa-solid fa-minus-circle"></i>
													</button>
												</td>
											`;
											categoryTable.querySelector("tbody").appendChild(row);

											row.querySelector("button").addEventListener("click", function() {
												row.remove();
											});
										}
									}
								});
							}
						});
					</script>
				</div>
			';

			$search = '<div id="tab-links" class="tab-pane">';
			$replace = $search . $mainCategoryHtml;

			$output = str_replace($search, $replace, $output);
		}
	}

	private function getCategoriesOptions(int $product_id): string {
		$this->load->model('catalog/category');
		$categories = $this->model_catalog_category->getCategories(['sort'=>'name']);

		$main_category = $this->getProductMainCategory($product_id);

		$options = '';
		foreach ($categories as $category) {
			$selected = ($category['category_id'] == $main_category) ? ' selected' : '';
			$options .= '<option value="' . $category['category_id'] . '"' . $selected . '>' . $category['name'] . '</option>';
		}

		return $options;
	}

	private function getProductMainCategory(int $product_id): int {
		$query = $this->db->query("SELECT category_id FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "' AND main_category = 1 LIMIT 1");

		return $query->num_rows ? (int)$query->row['category_id'] : 0;
	}

	public function onProductSave($route, $args, $output): void {
		$trigger_separator = version_compare(VERSION,'4.0.2.3', '>') ? '.' : '/';
		if ($route == 'catalog/product'.$trigger_separator.'addProduct') {
			$product_id = $output;
			$data = $args[0];
		} else {
			$product_id = $args[0];
			$data = $args[1];
		}

		if (isset($data['main_category']) && (int)$data['main_category'] > 0) {
			$main_category = (int)$data['main_category'];

			$this->db->query("UPDATE " . DB_PREFIX . "product_to_category 
				SET main_category = 0 
				WHERE product_id = '" . (int)$product_id . "'");

			$this->db->query("UPDATE " . DB_PREFIX . "product_to_category 
				SET main_category = 1 
				WHERE product_id = '" . (int)$product_id . "' 
				  AND category_id = '" . (int)$main_category . "'");
		}
	}
	
}